DROP TRIGGER CIS.CIS_VLDTN_STATUS_TY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_STATUS_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_STATUS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then


     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
     END IF;


INSERT INTO CIS_VLDTN_STATUS_TYPE_H( CIS_VLDTN_STATUS_TYPE_H_ID,

CIS_VLDTN_STATUS_TYPE_ID,

VLDTN_STATUS_TYPE_NM,

VLDTN_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_STATUS_TYPE_H_S.nextval
,

:old.CIS_VLDTN_STATUS_TYPE_ID,

:old.VLDTN_STATUS_TYPE_NM,

:old.VLDTN_STATUS_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;

      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
          OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
          CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;

INSERT INTO CIS_VLDTN_STATUS_TYPE_H( CIS_VLDTN_STATUS_TYPE_H_ID,

CIS_VLDTN_STATUS_TYPE_ID,

VLDTN_STATUS_TYPE_NM,

VLDTN_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_STATUS_TYPE_H_S.nextval
,

:new.CIS_VLDTN_STATUS_TYPE_ID,

:new.VLDTN_STATUS_TYPE_NM,

:new.VLDTN_STATUS_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_VLDTN_STATUS_TY_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_VLDTN_RSLT_CLOB_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_RSLT_CLOB_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_RSLT_CLOB
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;


begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_VLDTN_RSLT_CLOB_H( CIS_VLDTN_RSLT_CLOB_H_ID,

CIS_VLDTN_RSLT_ID,

CRCTD_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_CLOB_H_S.nextval
,

:old.CIS_VLDTN_RSLT_ID,

:old.CRCTD_DATA,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
'D');

else
      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;


      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;


INSERT INTO CIS_VLDTN_RSLT_CLOB_H( CIS_VLDTN_RSLT_CLOB_H_ID,

CIS_VLDTN_RSLT_ID,

CRCTD_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_CLOB_H_S.nextval
,

:new.CIS_VLDTN_RSLT_ID,

:new.CRCTD_DATA,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
mDML);

end if;

end CIS_VLDTN_RSLT_CLOB_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_VLDTN_RSLT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_RSLT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_RSLT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_VLDTN_RSLT_H( CIS_VLDTN_RSLT_H_ID,

CIS_VLDTN_RSLT_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

CRCTD_STTS_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_H_S.nextval
,

:old.CIS_VLDTN_RSLT_ID,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

:old.CRCTD_STTS_ID,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;


       IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
           OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
       THEN
           CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
       END IF;

INSERT INTO CIS_VLDTN_RSLT_H( CIS_VLDTN_RSLT_H_ID,

CIS_VLDTN_RSLT_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

CRCTD_STTS_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_H_S.nextval
,

:new.CIS_VLDTN_RSLT_ID,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

:new.CRCTD_STTS_ID,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_VLDTN_RSLT_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_VLDTN_PRBLM_TYP_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_PRBLM_TYP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_PRBLM_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_VLDTN_PRBLM_TYPE_H( CIS_VLDTN_PRBLM_TYPE_H_ID,

CIS_VLDTN_PRBLM_TYPE_ID,

VLDTN_PRBLM_TYPE_NM,

VLDTN_PRBLM_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_PRBLM_TYPE_H_S.nextval
,

:old.CIS_VLDTN_PRBLM_TYPE_ID,

:old.VLDTN_PRBLM_TYPE_NM,

:old.VLDTN_PRBLM_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_VLDTN_PRBLM_TYPE_H( CIS_VLDTN_PRBLM_TYPE_H_ID,

CIS_VLDTN_PRBLM_TYPE_ID,

VLDTN_PRBLM_TYPE_NM,

VLDTN_PRBLM_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_PRBLM_TYPE_H_S.nextval
,

:new.CIS_VLDTN_PRBLM_TYPE_ID,

:new.VLDTN_PRBLM_TYPE_NM,

:new.VLDTN_PRBLM_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_VLDTN_PRBLM_TYP_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_VLDTN_PRBLM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_PRBLM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_PRBLM
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;


begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_VLDTN_PRBLM_H( CIS_VLDTN_PRBLM_H_ID,

CIS_VLDTN_PRBLM_ID,

CIS_VLDTN_RSLT_ID,

CIS_VLDTN_PRBLM_TYPE_ID,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_VLDTN_PRBLM_H_S.nextval
,

:old.CIS_VLDTN_PRBLM_ID,

:old.CIS_VLDTN_RSLT_ID,

:old.CIS_VLDTN_PRBLM_TYPE_ID,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_VLDTN_PRBLM_H( CIS_VLDTN_PRBLM_H_ID,

CIS_VLDTN_PRBLM_ID,

CIS_VLDTN_RSLT_ID,

CIS_VLDTN_PRBLM_TYPE_ID,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_VLDTN_PRBLM_H_S.nextval
,

:new.CIS_VLDTN_PRBLM_ID,

:new.CIS_VLDTN_RSLT_ID,

:new.CIS_VLDTN_PRBLM_TYPE_ID,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_VLDTN_PRBLM_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_STAT_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_STAT_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_STAT_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
     END IF;


INSERT INTO CIS_STAT_TYPE_H( CIS_STAT_TYPE_H_ID,

CIS_STAT_TYPE_ID,

STAT_TYPE_NM,

STAT_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_STAT_TYPE_H_S.nextval
,

:old.CIS_STAT_TYPE_ID,

:old.STAT_TYPE_NM,

:old.STAT_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;

      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;

INSERT INTO CIS_STAT_TYPE_H( CIS_STAT_TYPE_H_ID,

CIS_STAT_TYPE_ID,

STAT_TYPE_NM,

STAT_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_STAT_TYPE_H_S.nextval
,

:new.CIS_STAT_TYPE_ID,

:new.STAT_TYPE_NM,

:new.STAT_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_STAT_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_RULE_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_RULE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_RULE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_RULE_TYPE_H( CIS_RULE_TYPE_H_ID,

CIS_RULE_TYPE_ID,

RULE_TYPE_NM,

RULE_TYPE_DESC_TX,


RULE_VERSION_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_RULE_TYPE_H_S.nextval
,

:old.CIS_RULE_TYPE_ID,

:old.RULE_TYPE_NM,

:old.RULE_TYPE_DESC_TX,

:old.RULE_VERSION_TX,

:old.REC_MDFD_CNT
,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;


      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
          OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
          CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;


INSERT INTO CIS_RULE_TYPE_H( CIS_RULE_TYPE_H_ID,

CIS_RULE_TYPE_ID,

RULE_TYPE_NM,

RULE_TYPE_DESC_TX,


RULE_VERSION_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_RULE_TYPE_H_S.nextval
,

:new.CIS_RULE_TYPE_ID,

:new.RULE_TYPE_NM,

:new.RULE_TYPE_DESC_TX,

:new.RULE_VERSION_TX,

:new.REC_MDFD_CNT
,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_RULE_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PURPOSE_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PURPOSE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PURPOSE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PURPOSE_TYPE_H( CIS_PURP_TYPE_H_ID,

CIS_PURP_TYPE_ID,

PURP_TYPE_NM,

PURP_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PURPOSE_TYPE_H_S.nextval
,

:old.CIS_PURP_TYPE_ID,

:old.PURP_TYPE_NM,

:old.PURP_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_PURPOSE_TYPE_H( CIS_PURP_TYPE_H_ID,

CIS_PURP_TYPE_ID,

PURP_TYPE_NM,

PURP_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PURPOSE_TYPE_H_S.nextval
,

:new.CIS_PURP_TYPE_ID,

:new.PURP_TYPE_NM,

:new.PURP_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PURPOSE_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PROVENANCE_BIUR_TRGR;

CREATE OR REPLACE TRIGGER CIS."CIS_PROVENANCE_BIUR_TRGR" BEFORE INSERT OR UPDATE
  ON CIS.CIS_PROVENANCE
 FOR EACH ROW
declare
mDML char(1) ;
begin
:new.REC_CRTD_DT:=sysdate;

cis_provenance_values_pkg.g_src_aplctn_party_id := :new.src_aplctn_party_id;
cis_provenance_values_pkg.g_rec_crtd_dt := :new.rec_crtd_dt;
cis_provenance_values_pkg.g_rec_crtr_party_id := :new.rec_crtr_party_id;


END;
/
DROP TRIGGER CIS.CIS_PREF_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PREF_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PREF_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;

begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PREF_TYPE_H( CIS_PREF_TYPE_H_ID,

CIS_PREF_TYPE_ID,

PREF_TYPE_NM,

PREF_TYPE_DESC_TX,


PREF_DOMAIN_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_PREF_TYPE_H_S.nextval
,

:old.CIS_PREF_TYPE_ID,

:old.PREF_TYPE_NM,

:old.PREF_TYPE_DESC_TX,

:old.PREF_DOMAIN_TX,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;


INSERT INTO CIS_PREF_TYPE_H( CIS_PREF_TYPE_H_ID,

CIS_PREF_TYPE_ID,

PREF_TYPE_NM,

PREF_TYPE_DESC_TX,


PREF_DOMAIN_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_PREF_TYPE_H_S.nextval
,

:new.CIS_PREF_TYPE_ID,

:new.PREF_TYPE_NM,

:new.PREF_TYPE_DESC_TX,

:new.PREF_DOMAIN_TX,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PREF_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PHONE_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PHONE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PHONE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;


begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PHONE_TYPE_H( CIS_PHONE_TYPE_H_ID,

CIS_PHONE_TYPE_ID,

PHONE_TYPE_NM,

PHONE_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PHONE_TYPE_H_S.nextval
,

:old.CIS_PHONE_TYPE_ID,

:old.PHONE_TYPE_NM,

:old.PHONE_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
       mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;


INSERT INTO CIS_PHONE_TYPE_H( CIS_PHONE_TYPE_H_ID,

CIS_PHONE_TYPE_ID,

PHONE_TYPE_NM,

PHONE_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PHONE_TYPE_H_S.nextval
,

:new.CIS_PHONE_TYPE_ID,

:new.PHONE_TYPE_NM,

:new.PHONE_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PHONE_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PARTY_SRC_ID_TY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_SRC_ID_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_SRC_ID_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_PARTY_SRC_ID_TYPE_H( CIS_PARTY_SRC_ID_TYPE_H_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID_TYPE_NM,

PARTY_SRC_ID_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_SRC_ID_TYPE_H_S.nextval
,

:old.CIS_PARTY_SRC_ID_TYPE_ID,

:old.PARTY_SRC_ID_TYPE_NM,

:old.PARTY_SRC_ID_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
    if UPDATING then
       mDML := 'U';
    else
       mDML := 'I' ;
    end if;

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_PARTY_SRC_ID_TYPE_H( CIS_PARTY_SRC_ID_TYPE_H_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID_TYPE_NM,

PARTY_SRC_ID_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_SRC_ID_TYPE_H_S.nextval
,

:new.CIS_PARTY_SRC_ID_TYPE_ID,

:new.PARTY_SRC_ID_TYPE_NM,

:new.PARTY_SRC_ID_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PARTY_SRC_ID_TY_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PARTY_RLNSHP_TY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_RLNSHP_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_RLNSHP_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;


begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PARTY_RLNSHP_TYPE_H( CIS_PARTY_RLNSHP_TYPE_H_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

PARTY_RLNSHP_NM,

PARTY_RLNSHP_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID
, REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_TYPE_H_S.nextval
,

:old.CIS_PARTY_RLNSHP_TYPE_ID,

:old.PARTY_RLNSHP_NM,

:old.PARTY_RLNSHP_DESC_TX,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;

      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;


INSERT INTO CIS_PARTY_RLNSHP_TYPE_H( CIS_PARTY_RLNSHP_TYPE_H_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

PARTY_RLNSHP_NM,

PARTY_RLNSHP_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID
, REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_TYPE_H_S.nextval
,

:new.CIS_PARTY_RLNSHP_TYPE_ID,

:new.PARTY_RLNSHP_NM,

:new.PARTY_RLNSHP_DESC_TX,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PARTY_RLNSHP_TY_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PARTY_RLNSHP_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_RLNSHP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_RLNSHP
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PARTY_RLNSHP_H( CIS_PARTY_RLNSHP_H_ID,

CIS_PARTY_RLNSHP_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

CIS_PRI_PARTY_ID,


CIS_SEC_PARTY_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_H_S.nextval
,

:old.CIS_PARTY_RLNSHP_ID,

:old.CIS_PARTY_RLNSHP_TYPE_ID,

:old.CIS_PRI_PARTY_ID,

:old.CIS_SEC_PARTY_ID,

:old.EFCTV_START_DT,


:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;


      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;


INSERT INTO CIS_PARTY_RLNSHP_H( CIS_PARTY_RLNSHP_H_ID,

CIS_PARTY_RLNSHP_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

CIS_PRI_PARTY_ID,


CIS_SEC_PARTY_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_H_S.nextval
,

:new.CIS_PARTY_RLNSHP_ID,

:new.CIS_PARTY_RLNSHP_TYPE_ID,

:new.CIS_PRI_PARTY_ID,

:new.CIS_SEC_PARTY_ID,

:new.EFCTV_START_DT,


:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PARTY_RLNSHP_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_PARTY_INFO_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_INFO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_INFO
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;


begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_PARTY_INFO_H( CIS_PARTY_INFO_H_ID,

CIS_PARTY_INFO_ID,

CIS_PARTY_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_INFO_H_S.nextval
,

:old.CIS_PARTY_INFO_ID,

:old.CIS_PARTY_ID,

:old.CIS_PARTY_SRC_ID_TYPE_ID,

:old.PARTY_SRC_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;

      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_PARTY_INFO_H( CIS_PARTY_INFO_H_ID,

CIS_PARTY_INFO_ID,

CIS_PARTY_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_INFO_H_S.nextval
,

:new.CIS_PARTY_INFO_ID,

:new.CIS_PARTY_ID,

:new.CIS_PARTY_SRC_ID_TYPE_ID,

:new.PARTY_SRC_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_PARTY_INFO_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_INFLGHT_STATUS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_STATUS_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_STATUS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_INFLGHT_STATUS_TYPE_H( CIS_INFLGHT_STATUS_TYPE_H_ID,

CIS_INFLGHT_STATUS_TYPE_ID,

INFLGHT_STATUS_TYPE_NM,

INFLGHT_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_STATUS_TYPE_H_S.nextval
,

:old.CIS_INFLGHT_STATUS_TYPE_ID,

:old.INFLGHT_STATUS_TYPE_NM,

:old.INFLGHT_STATUS_TYPE_DESC_TX,


:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

         if UPDATING then
            mDML := 'U';
         else
            mDML := 'I' ;
        end if;

        IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
           OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
        THEN
           CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
        END IF;

INSERT INTO CIS_INFLGHT_STATUS_TYPE_H( CIS_INFLGHT_STATUS_TYPE_H_ID,

CIS_INFLGHT_STATUS_TYPE_ID,

INFLGHT_STATUS_TYPE_NM,

INFLGHT_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_STATUS_TYPE_H_S.nextval
,

:new.CIS_INFLGHT_STATUS_TYPE_ID,

:new.INFLGHT_STATUS_TYPE_NM,

:new.INFLGHT_STATUS_TYPE_DESC_TX,


:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_INFLGHT_STATUS_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_INFLGHT_DATA_ST_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_ST_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;


begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_INFLGHT_DATA_STATUS_H( CIS_INFLGHT_DATA_STATUS_H_ID,

CIS_INFLGHT_DATA_STATUS_ID,

CIS_INFLGHT_STATUS_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_STATUS_H_S.nextval
,

:old.CIS_INFLGHT_DATA_STATUS_ID,

:old.CIS_INFLGHT_STATUS_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
       if UPDATING then
          mDML := 'U';
       else
          mDML := 'I' ;
       end if;

       IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
          OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
      END IF;

INSERT INTO CIS_INFLGHT_DATA_STATUS_H( CIS_INFLGHT_DATA_STATUS_H_ID,

CIS_INFLGHT_DATA_STATUS_ID,

CIS_INFLGHT_STATUS_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_STATUS_H_S.nextval
,

:new.CIS_INFLGHT_DATA_STATUS_ID,

:new.CIS_INFLGHT_STATUS_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_INFLGHT_DATA_ST_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_INFLGHT_DATA_CL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_CL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA_CLOB
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin

if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_INFLGHT_DATA_CLOB_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

REQUEST_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_CLOB_H_S.nextval
,

:old.CIS_INFLGHT_DATA_ID,

:old.REQUEST_DATA,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
'D');

else
     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_INFLGHT_DATA_CLOB_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

REQUEST_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_CLOB_H_S.nextval
,

:new.CIS_INFLGHT_DATA_ID,

:new.REQUEST_DATA,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
mDML);

end if;

end CIS_INFLGHT_DATA_CL_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_INFLGHT_DATA_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_INFLGHT_DATA_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

CIS_INFLGHT_DATA_STATUS_ID,

ICN,


TRANSACTION_ID_TX,

TRANSACTION_DATE,

VLDTN_OVERRIDE_FLG,

VLDTN_PROOF,

FAULT_TO,

REPLY_TO,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_INFLGHT_DATA_H_S.nextval
,

:old.CIS_INFLGHT_DATA_ID,

:old.CIS_INFLGHT_DATA_STATUS_ID,

:old.ICN,

:old.TRANSACTION_ID_TX,

:old.TRANSACTION_DATE,

:old.VLDTN_OVERRIDE_FLG,

:old.VLDTN_PROOF,

:old.FAULT_TO,

:old.REPLY_TO,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

      if UPDATING then
         mDML := 'U';
      else
         mDML := 'I' ;
      end if;

      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;

INSERT INTO CIS_INFLGHT_DATA_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

CIS_INFLGHT_DATA_STATUS_ID,

ICN,


TRANSACTION_ID_TX,

TRANSACTION_DATE,

VLDTN_OVERRIDE_FLG,

VLDTN_PROOF,

FAULT_TO,

REPLY_TO,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_INFLGHT_DATA_H_S.nextval
,

:new.CIS_INFLGHT_DATA_ID,

:new.CIS_INFLGHT_DATA_STATUS_ID,

:new.ICN,

:new.TRANSACTION_ID_TX,

:new.TRANSACTION_DATE,

:new.VLDTN_OVERRIDE_FLG,

:new.VLDTN_PROOF,

:new.FAULT_TO,

:new.REPLY_TO,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_INFLGHT_DATA_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_EMAIL_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_EMAIL_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_EMAIL_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_EMAIL_TYPE_H( CIS_EMAIL_TYPE_H_ID,

CIS_EMAIL_TYPE_ID,

EMAIL_TYPE_NM,

EMAIL_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_EMAIL_TYPE_H_S.nextval
,

:old.CIS_EMAIL_TYPE_ID,

:old.EMAIL_TYPE_NM,

:old.EMAIL_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');
else
     if UPDATING then
        mDML := 'U';
     else
       mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_EMAIL_TYPE_H( CIS_EMAIL_TYPE_H_ID,

CIS_EMAIL_TYPE_ID,

EMAIL_TYPE_NM,

EMAIL_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_EMAIL_TYPE_H_S.nextval
,

:new.CIS_EMAIL_TYPE_ID,

:new.EMAIL_TYPE_NM,

:new.EMAIL_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_EMAIL_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_TYPE__AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_TYPE__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_TYPE_PRPS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;


begin
if  deleting then
     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
    OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_CONT_INFO_TYPE_PRPS_H( CIS_CONT_INFO_TYPE_PRPS_H_ID,

CIS_CONT_INFO_TYPE_PRPS_ID,

CIS_PURP_TYPE_ID,


CIS_CONT_INFO_TYPE_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_PRPS_H_S.nextval
,

:old.CIS_CONT_INFO_TYPE_PRPS_ID,

:old.CIS_PURP_TYPE_ID,

:old.CIS_CONT_INFO_TYPE_ID,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID
,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
       if UPDATING then
          mDML := 'U';
       else
          mDML := 'I' ;
       end if;

       IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
          OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
       THEN
          CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
       END IF;

INSERT INTO CIS_CONT_INFO_TYPE_PRPS_H( CIS_CONT_INFO_TYPE_PRPS_H_ID,

CIS_CONT_INFO_TYPE_PRPS_ID,

CIS_PURP_TYPE_ID,


CIS_CONT_INFO_TYPE_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_PRPS_H_S.nextval
,

:new.CIS_CONT_INFO_TYPE_PRPS_ID,

:new.CIS_PURP_TYPE_ID,

:new.CIS_CONT_INFO_TYPE_ID,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID
,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_TYPE__AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
    OR  cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_TYPE_H( CIS_CONT_INFO_TYPE_H_ID,

CIS_CONT_INFO_TYPE_ID,

CONT_INFO_TYPE_NM,


CONT_INFO_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_H_S.nextval
,

:old.CIS_CONT_INFO_TYPE_ID,

:old.CONT_INFO_TYPE_NM,

:old.CONT_INFO_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
    OR  cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_CONT_INFO_TYPE_H( CIS_CONT_INFO_TYPE_H_ID,

CIS_CONT_INFO_TYPE_ID,

CONT_INFO_TYPE_NM,


CONT_INFO_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_H_S.nextval
,

:new.CIS_CONT_INFO_TYPE_ID,

:new.CONT_INFO_TYPE_NM,

:new.CONT_INFO_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_TYPE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_STATU_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_STATU_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_STATUS_H( CIS_CONT_INFO_STATUS_H_ID,

CIS_CONT_INFO_STATUS_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CIS_EXT_STAT_TYPE_ID,

CIS_INT_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

COMNT_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_STATUS_H_S.nextval
,

:old.CIS_CONT_INFO_STATUS_ID,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CIS_EXT_STAT_TYPE_ID,

:old.CIS_INT_STAT_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.COMNT_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');
else

    if UPDATING then
       mDML := 'U';
    else
       mDML := 'I' ;
    end if;


    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_CONT_INFO_STATUS_H( CIS_CONT_INFO_STATUS_H_ID,

CIS_CONT_INFO_STATUS_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CIS_EXT_STAT_TYPE_ID,

CIS_INT_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

COMNT_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_STATUS_H_S.nextval
,

:new.CIS_CONT_INFO_STATUS_ID,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CIS_EXT_STAT_TYPE_ID,

:new.CIS_INT_STAT_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.COMNT_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_STATU_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_RULE__AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_RULE__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_RULE_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_RULE_STATUS_H( CIS_CONT_INFO_RULE_STATUS_H_ID,

CIS_CONT_INFO_RULE_STATUS_ID,

CIS_CONT_INFO_STATUS_ID,


CIS_RULE_TYPE_ID,

CIS_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_RULE_STATUS_H_S.nextval
,

:old.CIS_CONT_INFO_RULE_STATUS_ID,

:old.CIS_CONT_INFO_STATUS_ID,

:old.CIS_RULE_TYPE_ID,

:old.CIS_STAT_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
'D');
else

       if UPDATING then
          mDML := 'U';
      else
         mDML := 'I' ;
      end if;


      IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
         OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
      THEN
         CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
      END IF;


INSERT INTO CIS_CONT_INFO_RULE_STATUS_H( CIS_CONT_INFO_RULE_STATUS_H_ID,

CIS_CONT_INFO_RULE_STATUS_ID,

CIS_CONT_INFO_STATUS_ID,


CIS_RULE_TYPE_ID,

CIS_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_RULE_STATUS_H_S.nextval
,

:new.CIS_CONT_INFO_RULE_STATUS_ID,

:new.CIS_CONT_INFO_STATUS_ID,

:new.CIS_RULE_TYPE_ID,

:new.CIS_STAT_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,
mDML);

end if;

end CIS_CONT_INFO_RULE__AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_PURPO_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PURPO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PURPOSE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PURPOSE_H( CIS_CONT_INFO_PURPOSE_H_ID,

CIS_CONT_INFO_PURPOSE_ID,

CIS_CONT_INFO_ID,


CIS_PURP_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PURPOSE_H_S.nextval
,

:old.CIS_CONT_INFO_PURPOSE_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PURP_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:NEW.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PURPOSE_H( CIS_CONT_INFO_PURPOSE_H_ID,

CIS_CONT_INFO_PURPOSE_ID,

CIS_CONT_INFO_ID,


CIS_PURP_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PURPOSE_H_S.nextval
,

:new.CIS_CONT_INFO_PURPOSE_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PURP_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_PURPO_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_PROF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PROF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PROF
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PROF_H( CIS_CONT_INFO_PROF_H_ID,

CIS_CONT_INFO_PROF_ID,

CIS_PARTY_ID,

EFCTV_START_DT,


EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_PROF_H_S.nextval
,

:old.CIS_CONT_INFO_PROF_ID,

:old.CIS_PARTY_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
       mDML := 'I' ;
    end if;


    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PROF_H( CIS_CONT_INFO_PROF_H_ID,

CIS_CONT_INFO_PROF_ID,

CIS_PARTY_ID,

EFCTV_START_DT,


EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_PROF_H_S.nextval
,

:new.CIS_CONT_INFO_PROF_ID,

:new.CIS_PARTY_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_PROF_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_PREF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PREF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PREF
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PREF_H( CIS_CONT_INFO_PREF_H_ID,

CIS_CONT_INFO_PREF_ID,

CIS_CONT_INFO_ID,

CIS_PREF_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PREF_H_S.nextval
,

:old.CIS_CONT_INFO_PREF_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PREF_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
    if UPDATING then
       mDML := 'U';
    else
       mDML := 'I' ;
    end if;
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PREF_H( CIS_CONT_INFO_PREF_H_ID,

CIS_CONT_INFO_PREF_ID,

CIS_CONT_INFO_ID,

CIS_PREF_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PREF_H_S.nextval
,

:new.CIS_CONT_INFO_PREF_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PREF_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_PREF_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_PHONE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PHONE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PHONE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then
    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_PHONE_H( CIS_CONT_INFO_PHONE_H_ID,

CIS_CONT_INFO_PHONE_ID,

CIS_CONT_INFO_ID,

CIS_PHONE_TYPE_ID,


COUNTRY_CD,

AREA_CD,

EXCHANGE_CD,

END_POINT_RN,

EXTNTN_NO,

COMPLT_PHONE_NO,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PHONE_H_S.nextval
,

:old.CIS_CONT_INFO_PHONE_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PHONE_TYPE_ID,

:old.COUNTRY_CD,

:old.AREA_CD,

:old.EXCHANGE_CD,


:old.END_POINT_RN,

:old.EXTNTN_NO,

:old.COMPLT_PHONE_NO,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
       mDML := 'I' ;
     end if;

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;


INSERT INTO CIS_CONT_INFO_PHONE_H( CIS_CONT_INFO_PHONE_H_ID,

CIS_CONT_INFO_PHONE_ID,

CIS_CONT_INFO_ID,

CIS_PHONE_TYPE_ID,


COUNTRY_CD,

AREA_CD,

EXCHANGE_CD,

END_POINT_RN,

EXTNTN_NO,

COMPLT_PHONE_NO,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PHONE_H_S.nextval
,

:new.CIS_CONT_INFO_PHONE_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PHONE_TYPE_ID,

:new.COUNTRY_CD,

:new.AREA_CD,

:new.EXCHANGE_CD,


:new.END_POINT_RN,

:new.EXTNTN_NO,

:new.COMPLT_PHONE_NO,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_PHONE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_EMAIL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_EMAIL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_EMAIL
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:old.CIS_PROVENANCE_ID) ;
   END IF;

INSERT INTO CIS_CONT_INFO_EMAIL_H( CIS_CONT_INFO_EMAIL_H_ID,

CIS_CONT_INFO_EMAIL_ID,

CIS_EMAIL_TYPE_ID,

CIS_CONT_INFO_ID,


EMAIL_ADDR_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_EMAIL_H_S.nextval
,

:old.CIS_CONT_INFO_EMAIL_ID,

:old.CIS_EMAIL_TYPE_ID,

:old.CIS_CONT_INFO_ID,

:old.EMAIL_ADDR_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
    end if;

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
       CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_EMAIL_H( CIS_CONT_INFO_EMAIL_H_ID,

CIS_CONT_INFO_EMAIL_ID,

CIS_EMAIL_TYPE_ID,

CIS_CONT_INFO_ID,


EMAIL_ADDR_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_EMAIL_H_S.nextval
,

:new.CIS_CONT_INFO_EMAIL_ID,

:new.CIS_EMAIL_TYPE_ID,

:new.CIS_CONT_INFO_ID,

:new.EMAIL_ADDR_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_EMAIL_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_DATA__AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_DATA__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_DATA_QUALITY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        cis_provenance_values_pkg.populate_provenance_values(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_DATA_QUALITY_H( CIS_CONT_INFO_DATA_QUAL_H_ID,

CIS_CONT_INFO_DATA_QUAL_ID,

CIS_INFLGHT_DATA_ID,


CIS_CONT_INFO_ID,

EFCTV_START_DT,

EFCTV_END_DT,

RATING_SC,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_DATA_QUALITY_H_S.nextval
,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CIS_INFLGHT_DATA_ID,

:old.CIS_CONT_INFO_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.RATING_SC,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else
       if UPDATING then
          mDML := 'U';
       else
          mDML := 'I' ;
       end if;

       IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
          OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
       THEN
          cis_provenance_values_pkg.populate_provenance_values(:new.CIS_PROVENANCE_ID) ;
      END IF;

INSERT INTO CIS_CONT_INFO_DATA_QUALITY_H( CIS_CONT_INFO_DATA_QUAL_H_ID,

CIS_CONT_INFO_DATA_QUAL_ID,

CIS_INFLGHT_DATA_ID,


CIS_CONT_INFO_ID,

EFCTV_START_DT,

EFCTV_END_DT,

RATING_SC,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_DATA_QUALITY_H_S.nextval
,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CIS_INFLGHT_DATA_ID,

:new.CIS_CONT_INFO_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.RATING_SC,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_DATA__AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
   THEN
       cis_provenance_values_pkg.populate_provenance_values(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_H( CIS_CONT_INFO_H_ID,

CIS_CONT_INFO_ID,

CIS_CONT_INFO_TYPE_ID,

CIS_CONT_INFO_PROF_ID,


SRC_PARTY_INFO_ID,

CIS_PARTY_RLNSHP_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_H_S.nextval
,

:old.CIS_CONT_INFO_ID,

:old.CIS_CONT_INFO_TYPE_ID,

:old.CIS_CONT_INFO_PROF_ID,

:old.SRC_PARTY_INFO_ID,

:old.CIS_PARTY_RLNSHP_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

cis_provenance_values_pkg.G_SRC_APLCTN_PARTY_ID,cis_provenance_values_pkg.G_REC_CRTD_DT,cis_provenance_values_pkg.G_REC_CRTR_PARTY_ID, 'D');

else
   if UPDATING then
      mDML := 'U';
   else
      mDML := 'I' ;
    end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
     OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
     THEN
        cis_provenance_values_pkg.populate_provenance_values(:new.CIS_PROVENANCE_ID) ;
     END IF;

INSERT INTO CIS_CONT_INFO_H( CIS_CONT_INFO_H_ID,

CIS_CONT_INFO_ID,

CIS_CONT_INFO_TYPE_ID,

CIS_CONT_INFO_PROF_ID,


SRC_PARTY_INFO_ID,

CIS_PARTY_RLNSHP_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_H_S.nextval
,

:new.CIS_CONT_INFO_ID,

:new.CIS_CONT_INFO_TYPE_ID,

:new.CIS_CONT_INFO_PROF_ID,

:new.SRC_PARTY_INFO_ID,

:new.CIS_PARTY_RLNSHP_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_CONT_INFO_ADDRE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_ADDRE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_ADDRESS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare

mDML char(1) ;

begin
if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
 	cis_provenance_values_pkg.populate_provenance_values(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_CONT_INFO_ADDRESS_H( CIS_CONT_INFO_ADDR_H_ID,

CIS_CONT_INFO_ADDR_ID,

CIS_CONT_INFO_ID,

CIS_ADDRESS_TYPE_ID,


LINE_1,

LINE_2,

LINE_3,

LINE_4,

CITY_TX,

STATE_PRVNC_TX,

ZIP_5_CD,

ZIP_4_CD,

POSTAL_CD,

COUNTY_DISTRICT_TX,


PRVNC_TX,

TERTRY_TX,

COUNTRY_CD_TX,

ATTN_TO_TX,

IN_CARE_OF_TX,

GEO_CD_TX,

ADDR_BLOB_TX,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_ADDRESS_H_S.nextval
,

:old.CIS_CONT_INFO_ADDR_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_ADDRESS_TYPE_ID,

:old.LINE_1,

:old.LINE_2,

:old.LINE_3,

:old.LINE_4,

:old.CITY_TX,

:old.STATE_PRVNC_TX,

:old.ZIP_5_CD,

:old.ZIP_4_CD,

:old.POSTAL_CD,

:old.COUNTY_DISTRICT_TX,

:old.PRVNC_TX
,

:old.TERTRY_TX,

:old.COUNTRY_CD_TX,

:old.ATTN_TO_TX,

:old.IN_CARE_OF_TX,

:old.GEO_CD_TX,

:old.ADDR_BLOB_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID, 'D');

else

    if UPDATING then
       mDML := 'U';
    else
       mDML := 'I' ;
    end if;

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
        OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
        CIS_PROVENANCE_VALUES_PKG.POPULATE_PROVENANCE_VALUES(:new.CIS_PROVENANCE_ID) ;
    END IF;



INSERT INTO CIS_CONT_INFO_ADDRESS_H( CIS_CONT_INFO_ADDR_H_ID,

CIS_CONT_INFO_ADDR_ID,

CIS_CONT_INFO_ID,

CIS_ADDRESS_TYPE_ID,


LINE_1,

LINE_2,

LINE_3,

LINE_4,

CITY_TX,

STATE_PRVNC_TX,

ZIP_5_CD,

ZIP_4_CD,

POSTAL_CD,

COUNTY_DISTRICT_TX,


PRVNC_TX,

TERTRY_TX,

COUNTRY_CD_TX,

ATTN_TO_TX,

IN_CARE_OF_TX,

GEO_CD_TX,

ADDR_BLOB_TX,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_ADDRESS_H_S.nextval
,

:new.CIS_CONT_INFO_ADDR_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_ADDRESS_TYPE_ID,

:new.LINE_1,

:new.LINE_2,

:new.LINE_3,

:new.LINE_4,

:new.CITY_TX,

:new.STATE_PRVNC_TX,

:new.ZIP_5_CD,

:new.ZIP_4_CD,

:new.POSTAL_CD,

:new.COUNTY_DISTRICT_TX,

:new.PRVNC_TX
,

:new.TERTRY_TX,

:new.COUNTRY_CD_TX,

:new.ATTN_TO_TX,

:new.IN_CARE_OF_TX,

:new.GEO_CD_TX,

:new.ADDR_BLOB_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

cis_provenance_values_pkg.G_REC_CRTD_DT,cis_provenance_values_pkg.G_REC_CRTR_PARTY_ID,cis_provenance_values_pkg.G_SRC_APLCTN_PARTY_ID, mDML);

end if;

end CIS_CONT_INFO_ADDRE_AUDIR_TRGR;
/
DROP TRIGGER CIS.CIS_AUDIT_LOG_BIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_AUDIT_LOG_BIR_TRGR BEFORE INSERT
  ON CIS.CIS_AUDIT_LOG
FOR EACH ROW
declare
mDML char(1) ;
begin
:new.CIS_AUDIT_LOG_ID:=CIS_AUDIT_LOG_S.NEXTVAL ;
END;
/
DROP TRIGGER CIS.CIS_ADDRESS_TYPE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER CIS.CIS_ADDRESS_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_ADDRESS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;


begin
if  deleting then

     IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
     OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
    THEN
	cis_provenance_values_pkg.populate_provenance_values(:old.CIS_PROVENANCE_ID) ;
    END IF;

INSERT INTO CIS_ADDRESS_TYPE_H( CIS_ADDRESS_TYPE_H_ID,

CIS_ADDRESS_TYPE_ID,

ADDR_TYPE_NM,

ADDR_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD
)

VALUES


(CIS_ADDRESS_TYPE_H_S.nextval
,

:old.CIS_ADDRESS_TYPE_ID,

:old.ADDR_TYPE_NM,

:old.ADDR_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, 'D');

else

     if UPDATING then
        mDML := 'U';
     else
        mDML := 'I' ;
     end if;

    IF (cis_provenance_values_pkg.g_rec_crtd_dt IS NULL
       OR cis_provenance_values_pkg.g_rec_crtr_party_id IS NULL )
   THEN
         cis_provenance_values_pkg.populate_provenance_values(:new.CIS_PROVENANCE_ID) ;
   END IF;


INSERT INTO CIS_ADDRESS_TYPE_H( CIS_ADDRESS_TYPE_H_ID,

CIS_ADDRESS_TYPE_ID,

ADDR_TYPE_NM,

ADDR_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_ADDRESS_TYPE_H_S.nextval
,

:new.CIS_ADDRESS_TYPE_ID,

:new.ADDR_TYPE_NM,

:new.ADDR_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

CIS_PROVENANCE_VALUES_PKG.G_SRC_APLCTN_PARTY_ID,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTD_DT,CIS_PROVENANCE_VALUES_PKG.G_REC_CRTR_PARTY_ID, mDML);

end if;

end CIS_ADDRESS_TYPE_AUDIR_TRGR;
/
